/************************************************************************
 * \file: iap2_fill_buffer.h
 *
 * \version: $ $
 *
 * This header file declares functions required for filling the target buffer from the structure provided.
 *
 * \component: global definition file
 *
 * \author: Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright: (c) 2010 - 2016 ADIT Corporation
 *
 * CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY
 ***********************************************************************/

#ifndef IAP2_FILL_BUFFER_H
#define IAP2_FILL_BUFFER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_init.h"

/**
 * \addtogroup FillBuffer
 * @{
 */

 /***************************************************************************//**
 * Fills the details of AccessoryAuthenticationSerialNumberParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the AccessoryAuthenticationSerialNumberParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about AccessoryAuthenticationSerialNumberParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2AccessoryAuthenticationSerialNumberParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2AccessoryAuthenticationSerialNumberParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of AuthenticationCertificateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the AuthenticationCertificateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about AuthenticationCertificateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2AuthenticationCertificateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2AuthenticationCertificateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of AuthenticationResponseParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the AuthenticationResponseParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about AuthenticationResponseParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2AuthenticationResponseParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2AuthenticationResponseParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of IdentificationInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the IdentificationInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about IdentificationInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2IdentificationInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2IdentificationInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of IdentificationInformationUpdateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the IdentificationInformationUpdateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about IdentificationInformationUpdateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2IdentificationInformationUpdateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2IdentificationInformationUpdateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RequestAppLaunchParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RequestAppLaunchParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about RequestAppLaunchParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2RequestAppLaunchParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RequestAppLaunchParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of OOBBTPairingAccessoryInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the OOBBTPairingAccessoryInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about OOBBTPairingAccessoryInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2OOBBTPairingAccessoryInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2OOBBTPairingAccessoryInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of OOBBTPairingCompletionInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the OOBBTPairingCompletionInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about OOBBTPairingCompletionInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2OOBBTPairingCompletionInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2OOBBTPairingCompletionInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartRouteGuidanceUpdateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartRouteGuidanceUpdateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartRouteGuidanceUpdateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartRouteGuidanceUpdateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartRouteGuidanceUpdateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StopRouteGuidanceUpdateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StopRouteGuidanceUpdateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StopRouteGuidanceUpdateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StopRouteGuidanceUpdateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StopRouteGuidanceUpdateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of BluetoothComponentInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the BluetoothComponentInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about BluetoothComponentInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2BluetoothComponentInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2BluetoothComponentInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartBluetoothConnectionUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartBluetoothConnectionUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartBluetoothConnectionUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartBluetoothConnectionUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartBluetoothConnectionUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of AcceptCallParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the AcceptCallParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about AcceptCallParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2AcceptCallParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2AcceptCallParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of EndCallParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the EndCallParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about EndCallParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2EndCallParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2EndCallParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of HoldStatusUpdateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the HoldStatusUpdateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about HoldStatusUpdateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2HoldStatusUpdateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2HoldStatusUpdateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of InitiateCallParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the InitiateCallParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about InitiateCallParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2InitiateCallParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2InitiateCallParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of MuteStatusUpdateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the MuteStatusUpdateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about MuteStatusUpdateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2MuteStatusUpdateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2MuteStatusUpdateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of SendDTMFParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the SendDTMFParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about SendDTMFParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2SendDTMFParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2SendDTMFParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartCallStateUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartCallStateUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartCallStateUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartCallStateUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartCallStateUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartCommunicationsUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartCommunicationsUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartCommunicationsUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartCommunicationsUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartCommunicationsUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartListUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartListUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartListUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartListUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartListUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RequestDeviceAuthenticationChallengeResponseParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RequestDeviceAuthenticationChallengeResponseParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about RequestDeviceAuthenticationChallengeResponseParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2RequestDeviceAuthenticationChallengeResponseParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RequestDeviceAuthenticationChallengeResponseParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StatusExternalAccessoryProtocolSessionParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StatusExternalAccessoryProtocolSessionParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StatusExternalAccessoryProtocolSessionParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StatusExternalAccessoryProtocolSessionParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StatusExternalAccessoryProtocolSessionParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of AccessoryHIDReportParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the AccessoryHIDReportParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about AccessoryHIDReportParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2AccessoryHIDReportParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2AccessoryHIDReportParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartHIDParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartHIDParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartHIDParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartHIDParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartHIDParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StopHIDParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StopHIDParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StopHIDParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StopHIDParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StopHIDParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of LocationInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the LocationInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about LocationInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2LocationInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2LocationInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of PlayMediaLibraryCollectionParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the PlayMediaLibraryCollectionParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about PlayMediaLibraryCollectionParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2PlayMediaLibraryCollectionParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2PlayMediaLibraryCollectionParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of PlayMediaLibraryCurrentSelectionParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the PlayMediaLibraryCurrentSelectionParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about PlayMediaLibraryCurrentSelectionParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2PlayMediaLibraryCurrentSelectionParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2PlayMediaLibraryCurrentSelectionParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of PlayMediaLibraryItemsParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the PlayMediaLibraryItemsParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about PlayMediaLibraryItemsParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2PlayMediaLibraryItemsParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2PlayMediaLibraryItemsParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of PlayMediaLibrarySpecialParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the PlayMediaLibrarySpecialParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about PlayMediaLibrarySpecialParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2PlayMediaLibrarySpecialParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2PlayMediaLibrarySpecialParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartMediaLibraryUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartMediaLibraryUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartMediaLibraryUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartMediaLibraryUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartMediaLibraryUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StopMediaLibraryUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StopMediaLibraryUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StopMediaLibraryUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StopMediaLibraryUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StopMediaLibraryUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of SetNowPlayingInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the SetNowPlayingInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about SetNowPlayingInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2SetNowPlayingInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2SetNowPlayingInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartNowPlayingUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartNowPlayingUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartNowPlayingUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartNowPlayingUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartNowPlayingUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of PowerSourceUpdateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the PowerSourceUpdateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about PowerSourceUpdateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2PowerSourceUpdateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2PowerSourceUpdateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartPowerUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartPowerUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartPowerUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartPowerUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartPowerUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartTelephonyCallStateInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartTelephonyCallStateInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartTelephonyCallStateInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartTelephonyCallStateInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartTelephonyCallStateInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartTelephonyUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartTelephonyUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartTelephonyUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartTelephonyUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartTelephonyUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of VehicleStatusUpdateParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the VehicleStatusUpdateParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about VehicleStatusUpdateParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2VehicleStatusUpdateParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2VehicleStatusUpdateParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RequestVoiceOverConfigurationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RequestVoiceOverConfigurationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about RequestVoiceOverConfigurationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2RequestVoiceOverConfigurationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RequestVoiceOverConfigurationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RequestVoiceOverMoveCursorParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RequestVoiceOverMoveCursorParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about RequestVoiceOverMoveCursorParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2RequestVoiceOverMoveCursorParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RequestVoiceOverMoveCursorParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RequestVoiceOverScrollPageParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RequestVoiceOverScrollPageParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about RequestVoiceOverScrollPageParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2RequestVoiceOverScrollPageParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RequestVoiceOverScrollPageParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RequestVoiceOverSpeakTextParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RequestVoiceOverSpeakTextParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about RequestVoiceOverSpeakTextParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2RequestVoiceOverSpeakTextParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RequestVoiceOverSpeakTextParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartVoiceOverCursorUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartVoiceOverCursorUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartVoiceOverCursorUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartVoiceOverCursorUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartVoiceOverCursorUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartVoiceOverUpdatesParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartVoiceOverUpdatesParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about StartVoiceOverUpdatesParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2StartVoiceOverUpdatesParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartVoiceOverUpdatesParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of AccessoryWiFiConfigurationInformationParameter Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the AccessoryWiFiConfigurationInformationParameter has to be filled.
 * \param[in] paramStructure  Structure holding information about AccessoryWiFiConfigurationInformationParameter Parameter, which has to be sent to Apple Device, it should be of type iAP2AccessoryWiFiConfigurationInformationParameter.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2AccessoryWiFiConfigurationInformationParameter(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of BluetoothComponentStatus Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the BluetoothComponentStatus has to be filled.
 * \param[in] paramStructure  Structure holding information about BluetoothComponentStatus Parameter, which has to be sent to Apple Device, it should be of type iAP2BluetoothComponentStatus.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2BluetoothComponentStatus(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of BluetoothHIDComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the BluetoothHIDComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about BluetoothHIDComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2BluetoothHIDComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2BluetoothHIDComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of BluetoothTransportComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the BluetoothTransportComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about BluetoothTransportComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2BluetoothTransportComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2BluetoothTransportComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of ExternalAccessoryProtocol Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the ExternalAccessoryProtocol has to be filled.
 * \param[in] paramStructure  Structure holding information about ExternalAccessoryProtocol Parameter, which has to be sent to Apple Device, it should be of type iAP2ExternalAccessoryProtocol.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2ExternalAccessoryProtocol(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of FavoritesListProperties Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the FavoritesListProperties has to be filled.
 * \param[in] paramStructure  Structure holding information about FavoritesListProperties Parameter, which has to be sent to Apple Device, it should be of type iAP2FavoritesListProperties.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2FavoritesListProperties(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of iAP2HIDComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the iAP2HIDComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about iAP2HIDComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2iAP2HIDComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2iAP2HIDComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of LocationInformationComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the LocationInformationComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about LocationInformationComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2LocationInformationComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2LocationInformationComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of MediaItemAttributes Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the MediaItemAttributes has to be filled.
 * \param[in] paramStructure  Structure holding information about MediaItemAttributes Parameter, which has to be sent to Apple Device, it should be of type iAP2MediaItemAttributes.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2MediaItemAttributes(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of MediaItemProperties Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the MediaItemProperties has to be filled.
 * \param[in] paramStructure  Structure holding information about MediaItemProperties Parameter, which has to be sent to Apple Device, it should be of type iAP2MediaItemProperties.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2MediaItemProperties(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of MediaPlaylistContentTransferInfoRequest Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the MediaPlaylistContentTransferInfoRequest has to be filled.
 * \param[in] paramStructure  Structure holding information about MediaPlaylistContentTransferInfoRequest Parameter, which has to be sent to Apple Device, it should be of type iAP2MediaPlaylistContentTransferInfoRequest.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2MediaPlaylistContentTransferInfoRequest(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of MediaPlaylistProperties Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the MediaPlaylistProperties has to be filled.
 * \param[in] paramStructure  Structure holding information about MediaPlaylistProperties Parameter, which has to be sent to Apple Device, it should be of type iAP2MediaPlaylistProperties.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2MediaPlaylistProperties(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of PlaybackQueueListContentTransferInfoRequest Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the PlaybackQueueListContentTransferInfoRequest has to be filled.
 * \param[in] paramStructure  Structure holding information about PlaybackQueueListContentTransferInfoRequest Parameter, which has to be sent to Apple Device, it should be of type iAP2PlaybackQueueListContentTransferInfoRequest.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2PlaybackQueueListContentTransferInfoRequest(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RecentsListProperties Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RecentsListProperties has to be filled.
 * \param[in] paramStructure  Structure holding information about RecentsListProperties Parameter, which has to be sent to Apple Device, it should be of type iAP2RecentsListProperties.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RecentsListProperties(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of RouteGuidanceDisplayComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the RouteGuidanceDisplayComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about RouteGuidanceDisplayComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2RouteGuidanceDisplayComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2RouteGuidanceDisplayComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of SerialTransportComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the SerialTransportComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about SerialTransportComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2SerialTransportComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2SerialTransportComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of StartNowPlayingPlaybackAttributes Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the StartNowPlayingPlaybackAttributes has to be filled.
 * \param[in] paramStructure  Structure holding information about StartNowPlayingPlaybackAttributes Parameter, which has to be sent to Apple Device, it should be of type iAP2StartNowPlayingPlaybackAttributes.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2StartNowPlayingPlaybackAttributes(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of USBDeviceTransportComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the USBDeviceTransportComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about USBDeviceTransportComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2USBDeviceTransportComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2USBDeviceTransportComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of USBHostHIDComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the USBHostHIDComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about USBHostHIDComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2USBHostHIDComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2USBHostHIDComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of USBHostTransportComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the USBHostTransportComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about USBHostTransportComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2USBHostTransportComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2USBHostTransportComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of VehicleInformationComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the VehicleInformationComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about VehicleInformationComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2VehicleInformationComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2VehicleInformationComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of VehicleStatusComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the VehicleStatusComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about VehicleStatusComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2VehicleStatusComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2VehicleStatusComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

 /***************************************************************************//**
 * Fills the details of WirelessCarPlayTransportComponent Parameter to the target buffer which holds the message to be sent to Apple Device.
 * 
 * \param[out] TargetBuffer  Target Buffer to which the WirelessCarPlayTransportComponent has to be filled.
 * \param[in] paramStructure  Structure holding information about WirelessCarPlayTransportComponent Parameter, which has to be sent to Apple Device, it should be of type iAP2WirelessCarPlayTransportComponent.
 * \param[in,out] currentPosition  Current Position of the target buffer.
 * 
 * \return IAP2_OK  On Successful completion of filling the message to the target buffer.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_TYPE   When the type of the Parameter is unknown.
 * 
 * \see
 * \note
 *******************************************************************************/
S32 iAP2FillMsgBufiAP2WirelessCarPlayTransportComponent(U8* p_TargetBuffer, const void* paramStructure, U16* currentPosition);

/** @} */

#ifdef __cplusplus
}
#endif

#endif
